/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.Multilingual;

public abstract class AbstractUnit {
    protected static final int ABU_WRONG_INSERTION = 1;
    protected static final int ABU_INSERTED = 2;
    protected static final int ABU_NOT_READY = 4;
    protected static final int ABU_WRITE_PROTECTED = 8;
    protected static final int ABU_USER_PREVENTED = 16;
    protected static final int ABU_BUFFERED = 32;
    protected static final int ABU_EJECT_PREVENTED = 64;
    protected static final int ABU_BLINKING = 128;
    protected int abuNumber;
    protected int abuNumberOfModes;
    protected int abuCurrentMode;
    protected JButton abuModeButton;
    protected boolean abuConnected;
    protected boolean abuInserted;
    protected boolean abuWriteProtected;
    protected boolean abuBuffered;
    protected boolean abuEjectPrevented;
    protected boolean abuDisconnectable;
    protected boolean abuUnprotectable;
    protected boolean abuEjected;
    protected String abuPath;
    protected Box abuMenuBox;
    protected JCheckBox abuConnectCheckBox;
    protected JCheckBox abuProtectCheckBox;
    protected JButton abuOpenButton;
    protected JTextField abuOpenTextField;
    protected JButton abuEjectButton;

    public int abuGetNumberOfModes() {
        return 0;
    }

    public ImageIcon abuGetModeIcon(int n, boolean bl) {
        return null;
    }

    public String abuGetModeTextEn(int n, boolean bl) {
        return bl ? "Mode " + n + " / Change mode to " + (n + 1 < this.abuNumberOfModes ? n + 1 : 0) : "Mode " + n;
    }

    public String abuGetModeTextJa(int n, boolean bl) {
        return bl ? "\u30e2\u30fc\u30c9 " + n + " / \u30e2\u30fc\u30c9 " + (n + 1 < this.abuNumberOfModes ? n + 1 : 0) + " \u306b\u5207\u308a\u66ff\u3048\u308b" : "\u30e2\u30fc\u30c9 " + n;
    }

    public void abuSetMode(int n) {
        this.abuCurrentMode = n;
        this.abuUpdateModeButton();
    }

    public void abuUpdateModeButton() {
        if (this.abuNumberOfModes > 0) {
            boolean bl = this.abuConnected && !this.abuInserted;
            this.abuModeButton.setEnabled(bl);
            this.abuModeButton.setIcon(this.abuGetModeIcon(this.abuCurrentMode, true));
            this.abuModeButton.setDisabledIcon(this.abuGetModeIcon(this.abuCurrentMode, false));
            Multilingual.mlnToolTipText(this.abuModeButton, "en", this.abuGetModeTextEn(this.abuCurrentMode, bl), "ja", this.abuGetModeTextJa(this.abuCurrentMode, bl));
        }
    }

    public Box getMenuBox() {
        return this.abuMenuBox;
    }

    public boolean isConnected() {
        return this.abuConnected;
    }

    protected boolean hasBeenEjected() {
        boolean bl = this.abuEjected;
        this.abuEjected = false;
        return bl;
    }

    protected AbstractUnit(int n) {
        this.abuNumber = n;
        this.abuNumberOfModes = this.abuGetNumberOfModes();
        this.abuCurrentMode = 0;
        this.abuConnected = false;
        this.abuInserted = false;
        this.abuWriteProtected = false;
        this.abuBuffered = false;
        this.abuEjectPrevented = false;
        this.abuDisconnectable = true;
        this.abuUnprotectable = true;
        this.abuEjected = false;
        this.abuPath = "";
        ActionListener actionListener = new ActionListener(this){
            final /* synthetic */ AbstractUnit this$0;
            {
                AbstractUnit abstractUnit2 = abstractUnit;
                Objects.requireNonNull(abstractUnit2);
                this.this$0 = abstractUnit2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                switch (string = actionEvent.getActionCommand()) {
                    case "connect": {
                        if (this.this$0.abuConnectCheckBox.isSelected()) {
                            this.this$0.connect(true);
                            break;
                        }
                        this.this$0.disconnect();
                        break;
                    }
                    case "mode": {
                        if (!this.this$0.abuConnected || this.this$0.abuInserted) break;
                        this.this$0.abuSetMode(this.this$0.abuCurrentMode + 1 < this.this$0.abuNumberOfModes ? this.this$0.abuCurrentMode + 1 : 0);
                        break;
                    }
                    case "eject": {
                        this.this$0.eject();
                        break;
                    }
                    case "open": {
                        this.this$0.open();
                        break;
                    }
                    case "protect": {
                        if (this.this$0.abuProtectCheckBox.isSelected()) {
                            this.this$0.protect(true);
                            break;
                        }
                        this.this$0.unprotect();
                    }
                }
            }
        };
        Component[] componentArray = new Component[1];
        this.abuConnectCheckBox = Multilingual.mlnToolTipText(ComponentFactory.setEnabled(ComponentFactory.createIconCheckBox(false, LnF.LNF_NUMBER_IMAGE_ARRAY[this.abuNumber], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[this.abuNumber], LnF.LNF_NUMBER_IMAGE_ARRAY[this.abuNumber], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[this.abuNumber], "connect", actionListener), true), "en", "Connect", "ja", "\u63a5\u7d9a\u3059\u308b");
        componentArray[0] = this.abuConnectCheckBox;
        this.abuMenuBox = ComponentFactory.createHorizontalBox(componentArray);
        if (this.abuNumberOfModes > 0) {
            boolean bl = this.abuConnected && !this.abuInserted;
            this.abuModeButton = Multilingual.mlnToolTipText(ComponentFactory.setEnabled(ComponentFactory.createIconButton(this.abuGetModeIcon(this.abuCurrentMode, true), this.abuGetModeIcon(this.abuCurrentMode, false), "mode", actionListener), bl), "en", this.abuGetModeTextEn(this.abuCurrentMode, bl), "ja", this.abuGetModeTextJa(this.abuCurrentMode, bl));
            ComponentFactory.addComponents(this.abuMenuBox, this.abuModeButton);
        }
        this.abuEjectButton = Multilingual.mlnToolTipText(ComponentFactory.setEnabled(ComponentFactory.createImageButton(LnF.LNF_EJECT_IMAGE, LnF.LNF_EJECT_DISABLED_IMAGE, "eject", actionListener), false), "en", null, "ja", null);
        this.abuOpenButton = Multilingual.mlnToolTipText(ComponentFactory.setEnabled(ComponentFactory.setPreferredSize(ComponentFactory.setText(ComponentFactory.createButton(LnF.LNF_OPEN_IMAGE, LnF.LNF_OPEN_DISABLED_IMAGE, "open", actionListener), ""), LnF.lnfFontSize + 4, LnF.lnfFontSize + 4), false), "en", null, "ja", null);
        this.abuOpenTextField = ComponentFactory.addListener(ComponentFactory.setEditable(ComponentFactory.setPreferredSize(ComponentFactory.setHorizontalAlignment(ComponentFactory.createTextField("", 20), 0), 144, LnF.lnfFontSize + 4), false), new MouseAdapter(this){
            final /* synthetic */ AbstractUnit this$0;
            {
                AbstractUnit abstractUnit2 = abstractUnit;
                Objects.requireNonNull(abstractUnit2);
                this.this$0 = abstractUnit2;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!this.this$0.abuInserted) {
                    this.this$0.abuOpenButton.doClick();
                }
            }
        });
        this.abuProtectCheckBox = Multilingual.mlnToolTipText(ComponentFactory.setEnabled(ComponentFactory.createIconCheckBox(true, LnF.LNF_PROTECT_IMAGE, LnF.LNF_PROTECT_SELECTED_IMAGE, LnF.LNF_PROTECT_DISABLED_IMAGE, LnF.LNF_PROTECT_DISABLED_SELECTED_IMAGE, "protect", actionListener), false), "en", null, "ja", null);
        ComponentFactory.addComponents(this.abuMenuBox, this.abuEjectButton, this.abuOpenButton, this.abuOpenTextField, Box.createHorizontalGlue(), this.abuProtectCheckBox);
    }

    protected void connect(boolean bl) {
        if (this.abuConnected) {
            return;
        }
        this.abuConnected = true;
        this.abuDisconnectable = bl;
        this.abuConnectCheckBox.setSelected(true);
        this.abuConnectCheckBox.setEnabled(bl);
        Multilingual.mlnToolTipText(this.abuConnectCheckBox, "en", bl ? "Disconnect" : null, "ja", bl ? "\u5207\u308a\u96e2\u3059" : null);
        this.abuSetMode(this.abuCurrentMode);
        this.abuOpenButton.setEnabled(true);
        Multilingual.mlnToolTipText(this.abuOpenButton, "en", "Open", "ja", "\u958b\u304f");
    }

    protected void disconnect() {
        if (!this.abuConnected || this.abuInserted || !this.abuDisconnectable) {
            return;
        }
        this.abuConnected = false;
        this.abuConnectCheckBox.setSelected(false);
        Multilingual.mlnToolTipText(this.abuConnectCheckBox, "en", "Connect", "ja", "\u63a5\u7d9a\u3059\u308b");
        this.abuSetMode(this.abuCurrentMode);
        this.abuOpenButton.setEnabled(false);
        Multilingual.mlnToolTipText(this.abuOpenButton, "en", null, "ja", null);
    }

    protected void protect(boolean bl) {
        if (!this.abuInserted || this.abuWriteProtected) {
            return;
        }
        this.abuWriteProtected = true;
        this.abuUnprotectable = bl;
        this.abuProtectCheckBox.setSelected(true);
        this.abuProtectCheckBox.setEnabled(bl);
        Multilingual.mlnToolTipText(this.abuProtectCheckBox, "en", "Write-Protected", "ja", "\u66f8\u304d\u8fbc\u307f\u304c\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059");
    }

    protected void unprotect() {
        if (!(this.abuInserted && this.abuWriteProtected && this.abuUnprotectable)) {
            return;
        }
        this.abuWriteProtected = false;
        this.abuProtectCheckBox.setSelected(false);
        Multilingual.mlnToolTipText(this.abuProtectCheckBox, "en", "Write-Enabled", "ja", "\u66f8\u304d\u8fbc\u307f\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u3059");
    }

    protected void prevent() {
        if (!this.abuConnected || !this.abuInserted || this.abuEjectPrevented) {
            return;
        }
        this.abuEjectPrevented = true;
        this.abuOpenButton.setEnabled(false);
        Multilingual.mlnToolTipText(this.abuOpenButton, "en", null, "ja", null);
        this.abuEjectButton.setEnabled(false);
        Multilingual.mlnToolTipText(this.abuEjectButton, "en", null, "ja", null);
    }

    protected void allow() {
        if (!(this.abuConnected && this.abuInserted && this.abuEjectPrevented)) {
            return;
        }
        this.abuEjectPrevented = false;
        this.abuOpenButton.setEnabled(true);
        Multilingual.mlnToolTipText(this.abuOpenButton, "en", "Open", "ja", "\u958b\u304f");
        this.abuEjectButton.setEnabled(true);
        Multilingual.mlnToolTipText(this.abuEjectButton, "en", "Eject", "ja", "\u30a4\u30b8\u30a7\u30af\u30c8\u3059\u308b");
    }

    protected boolean eject() {
        if (!this.abuConnected || this.abuEjectPrevented) {
            return false;
        }
        if (!this.abuInserted) {
            return true;
        }
        this.abuInserted = false;
        this.abuWriteProtected = false;
        this.abuBuffered = false;
        this.abuEjected = true;
        this.abuPath = "";
        this.abuOpenTextField.setText("");
        this.abuConnectCheckBox.setEnabled(this.abuDisconnectable);
        Multilingual.mlnToolTipText(this.abuConnectCheckBox, "en", this.abuDisconnectable ? "Disconnect" : null, "ja", this.abuDisconnectable ? "\u5207\u308a\u96e2\u3059" : null);
        this.abuSetMode(this.abuCurrentMode);
        this.abuProtectCheckBox.setSelected(true);
        this.abuProtectCheckBox.setEnabled(false);
        Multilingual.mlnToolTipText(this.abuProtectCheckBox, "en", null, "ja", null);
        this.abuEjectButton.setEnabled(false);
        Multilingual.mlnToolTipText(this.abuEjectButton, "en", null, "ja", null);
        return true;
    }

    protected boolean open() {
        if (!this.abuConnected || this.abuInserted && this.abuEjectPrevented) {
            return false;
        }
        return this.eject();
    }

    protected boolean insert(String string, boolean bl) {
        if (string.length() == 0 || !this.abuConnected || this.abuInserted && this.abuEjectPrevented) {
            return false;
        }
        this.abuInserted = true;
        String string2 = this.abuPath = string;
        while (2 < string2.length() && (string2.endsWith("/.") || string2.endsWith("\\."))) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        this.abuOpenTextField.setText(string2);
        this.abuOpenTextField.setCaretPosition(string2.length());
        this.abuConnectCheckBox.setEnabled(false);
        Multilingual.mlnToolTipText(this.abuConnectCheckBox, "en", null, "ja", null);
        this.abuSetMode(this.abuCurrentMode);
        this.abuProtectCheckBox.setEnabled(true);
        this.abuProtectCheckBox.setSelected(false);
        Multilingual.mlnToolTipText(this.abuProtectCheckBox, "en", "Write-Enabled", "ja", "\u66f8\u304d\u8fbc\u307f\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u3059");
        this.abuEjectButton.setEnabled(true);
        Multilingual.mlnToolTipText(this.abuEjectButton, "en", "Eject", "ja", "\u30a4\u30b8\u30a7\u30af\u30c8\u3059\u308b");
        if (bl) {
            this.protect(false);
        }
        if (!this.load(string)) {
            this.eject();
            return false;
        }
        return true;
    }

    protected boolean load(String string) {
        return true;
    }

    protected String getName() {
        return this.abuPath;
    }
}

